#!/bin/sh
# Update the Trapjumper software

BASEDIR=$(dirname "$0")
echo "$BASEDIR"

FILEDIR=/home/pi/PE2327/bin
TEMPDIR=/home/pi/PE2327/temp
ADMINDIR=/var/www/html

function reset(){
	echo "reset"
	sudo rm -r $FILEDIR
	mkdir $FILEDIR
	sudo mv $TEMPDIR/* $FILEDIR/
	sudo rm -r $TEMPDIR
}

if [ -d $FILEDIR ]
then 
	echo "creating temporary files"
	sudo mkdir $TEMPDIR
	sudo mv $FILEDIR/* $TEMPDIR/
fi


echo "copying Files"

sudo cp $BASEDIR/PE2327 $FILEDIR/
if [ -f $FILEDIR/PE2327 ]
then
	echo "Application copied"
else 
	echo "failed to copy application"
	reset
	exit 2
fi

sudo cp $BASEDIR/PE2327_startup.sh $FILEDIR/
if [ -f $FILEDIR/PE2327_startup.sh ]
then
	echo "startup script copied"
else 
	echo "failed to copy startup script"
	reset
	exit 2
fi

sudo cp $BASEDIR/PE2327_closeapp.sh $FILEDIR/
if [ -f $FILEDIR/PE2327_closeapp.sh ]
then
	echo "close script copied"
else 
	echo "failed to copy close script"
	reset
	exit 2
fi

sudo cp $BASEDIR/PE2327_upgrade.sh $FILEDIR/
if [ -f $FILEDIR/PE2327_upgrade.sh ]
then
	echo "upgrade script copied"
else 
	echo "failed to copy upgrade script"
	reset
	exit 2
fi

sudo cp $BASEDIR/PE2327_shutdown.sh $FILEDIR/
if [ -f $FILEDIR/PE2327_shutdown.sh ]
then
	echo "shutdown script copied"
else 
	echo "failed to copy shutdown script"
	reset
	exit 2
fi

sudo cp $BASEDIR/PE2327_gpio_write.sh $FILEDIR/
if [ -f $FILEDIR/PE2327_gpio_write.sh ]
then
	echo "GPIO script copied"
else 
	echo "failed to copy GPIO script"
	reset
	exit 2
fi

sudo cp $BASEDIR/PE2327_gpio_read.sh $FILEDIR/
if [ -f $FILEDIR/PE2327_gpio_read.sh ]
then
	echo "GPIO read script copied"
else 
	echo "failed to copy GPIO read script"
	reset
	exit 2
fi

sudo cp $BASEDIR/PE2327_sonde_en_write.sh $FILEDIR/
if [ -f $FILEDIR/PE2327_sonde_en_write.sh ]
then
	echo "Sonde enable write script copied"
else 
	echo "failed to copy Sonde enable script"
	reset
	exit 2
fi


sudo cp $BASEDIR/PE2327_bb_read.sh $FILEDIR/
if [ -f $FILEDIR/PE2327_bb_read.sh ]
then
	echo "busy bee script copied"
else 
	echo "failed to copy busy bee script"
	reset
	exit 2
fi

sudo cp $BASEDIR/PE2327_gstreamer.sh $FILEDIR/
if [ -f $FILEDIR/PE2327_gstreamer.sh ]
then
	echo "gstreamer script copied"
else 
	echo "failed to copy gstreamer script"
	reset
	exit 2
fi

sudo cp $BASEDIR/PE2327_stream_start.sh $FILEDIR/
if [ -f $FILEDIR/PE2327_stream_start.sh ]
then
	echo "PE2327_stream_start script copied"
else 
	echo "failed to copy PE2327_stream_start script"
	reset
	exit 2
fi

sudo cp $BASEDIR/PE2327_stream_stop.sh $FILEDIR/
if [ -f $FILEDIR/PE2327_stream_stop.sh ]
then
	echo "PE2327_stop_start script copied"
else 
	echo "failed to copy PE2327_stop_start script"
	reset
	exit 2
fi

sudo cp $BASEDIR/PE2327_usb_monitor.sh $FILEDIR/
if [ -f $FILEDIR/PE2327_usb_monitor.sh ]
then
	echo "usb monitor script copied"
else 
	echo "failed to copy usb monitor script"
	reset
	exit 2
fi

sudo cp $BASEDIR/logrotate.conf /etc/.
if [ -f /etc/logrotate.conf ]
then
	echo "copied log rotate conf file"
else
	echo "failed to copy log rotate conf script"
fi

sudo cp $BASEDIR/splash.png /opt/.
if [ -f /opt/splash.png ]
then
	echo "copied splash screen"
else
	echo "failed to copy splash screen"
fi

sudo cp $BASEDIR/splashStream.png /opt/.
if [ -f /opt/splashStream.png ]
then
	echo "copied splash stream screen"
else
	echo "failed to copy splash stream screen"
fi

# sudo cp $BASEDIR/AdminPage/index.html $ADMINDIR/

# copy admin page files across
sudo cp $BASEDIR/AdminPage/* $ADMINDIR/

# check that html files have copied across
if [ -f $ADMINDIR/index.html ]
then
	echo "index.html page copied"
else 
	echo "failed to copy index.html"
	reset
	exit 2
fi

if [ -f $ADMINDIR/testPage.html ]
then
	echo "testPage.html page copied"
else 
	echo "failed to copy testPage.html"
	reset
	exit 2
fi

if [ -f $ADMINDIR/phpFunctions.php ]
then
	echo "php functions file copied"
else 
	echo "failed to copy phpFunction.php"
	reset
	exit 2
fi

sudo cp $BASEDIR/xRangeConfig.ini $FILEDIR/
if [ -f $FILEDIR/xRangeConfig.ini ]
then
	echo "config settings file copied"
else 
	echo "failed to copy config settings file"
	reset
	exit 2
fi


echo "setting up service"
sudo cp $BASEDIR/PE2327_service.service /lib/systemd/system/
sudo chmod 644 /lib/systemd/system/PE2327_service.service
sudo systemctl daemon-reload
sudo systemctl enable PE2327_service.service


# remove temporary files
sudo rm -r $TEMPDIR
#set permissions
sudo chmod +x $FILEDIR/PE2327
#Success
exit 3
