#!/bin/sh
# Update the Trapjumper software
BASEDIR=$(dirname "$0")
echo "$BASEDIR"

USB_PATH=""
UPGRADE_FOLDER_NAME="upgrade"
UPGRADE_FOLDER_NAME_PEL="PE2327"

# turn off LEDs by disabling LED-nEn
sudo bash  ${BASEDIR}/PE2327_gpio_write.sh "21" "1"

sudo bash  ${BASEDIR}/PE2327_gpio_write.sh "18" "0"

sudo bash  ${BASEDIR}/PE2327_gpio_write.sh "41" "1"

sudo bash  ${BASEDIR}/PE2327_gpio_write.sh "43" "0"

sudo bash  ${BASEDIR}/PE2327_gpio_write.sh "44" "0"

echo "pi:raspberry" | sudo chpasswd

if [ -b /dev/sda ]
then 
	# mount maybe
	stty -F /dev/serial0 115200
	echo -e "BOOT:READY\r\n" > /dev/serial0
	sudo mount -a
	sleep 2

	# allow for muliple partitions or USBs
	for i in /media/pi/*
	do
		USB_PATH=$i
		echo "$i"
		# verify upgrade folder exists on usb
		if [ -d $USB_PATH/$UPGRADE_FOLDER_NAME ] || [ -d $USB_PATH/$UPGRADE_FOLDER_NAME_PEL ]
		then
			# USB upgrade found, 1 = inprogress
			echo -e "UPGRADE:STATE 1\r\n" > /dev/serial0
			sleep 2
                       
			# check if script exists
			if [ -f ${USB_PATH}/upgrade/PE2327_upgrade.sh ]
			then
				# USB upgrade found, 1 = inprogress
				echo -e "UPGRADE:STATE 1\r\n" > /dev/serial0
				# kill application
				bash ${BASEDIR}/PE2327_closeapp.sh
				# run upgrade on USB
				bash ${USB_PATH}/upgrade/PE2327_upgrade.sh
				OUTPUT=$?
				echo $OUTPUT
				# check output
				if [ $OUTPUT == "3" ]
				then
					#  3 = success
					echo -e "UPGRADE:STATE 3\r\n" > /dev/serial0
				else
					# else script failed
					echo -e "UPGRADE:STATE 2\r\n" > /dev/serial0
				fi
				# shutdown pi
				sudo shutdown now
				exit 0
			elif [ -f ${USB_PATH}/PE2327/PE2327_upgrade.sh ]
			then
				# USB upgrade found, 1 = inprogress
				echo -e "UPGRADE:STATE 1\r\n" > /dev/serial0
				# kill application
				bash ${BASEDIR}/PE2327_closeapp.sh
				# run upgrade on USB
				bash ${USB_PATH}/PE2327/PE2327_upgrade.sh
				OUTPUT=$?
				echo $OUTPUT
				# check output
				if [ $OUTPUT == "3" ]
				then
					#  3 = success
					echo -e "UPGRADE:STATE 3\r\n" > /dev/serial0
				else
					# else script failed
					echo -e "UPGRADE:STATE 2\r\n" > /dev/serial0
				fi
				# shutdown pi
				sudo shutdown now
				exit 0
			else
				# upgrade folder found by no upgrade script				
				echo -e "UPGRADE:STATE 2\r\n" > /dev/serial0
				# shutdown & exit
				sudo shutdown now
				exit 1			
			fi
		else
			# run PE2327 application
			echo "no upgrade on USB"
		fi
	done
	echo "no upgrade found on USB"
else 
	echo "no USB"
fi

echo 15 | sudo tee /sys/module/adv7180/parameters/dbg_input

v4l2-ctl -s pal
while true
do
	${BASEDIR}/PE2327
	# kill gst
	sudo killall gst-launch-1.0
	sleep 1	# wait for gst to finish
	retval=$?
	echo $retval
	if [ $retval -eq 143 ]
	then
		echo recieved a SIGTERM
		exit 0
	fi
done
exit 0

