<?php

# get maxprobe detected
function getMaxprobeDetected() {
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $mxp = $ini_file['Maxprobe']['Detected'];
    if ($mxp == "0" || empty($mxp)) {
        echo "Not Connected";
    }
    else {
        echo "Connected";
    }
}

# get internal temperature
function getInternalTemperature() {
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $intTemp = $ini_file['Temperature']['Internal'];
    if (empty($intTemp)) {
        echo "N/A";
        return "N/A"; 
    }
    else {
        echo $intTemp;
        return $intTemp;
    }
}

# get internal thermistor temperature
function getInternalThermistorTemperature() {
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $intTemp = $ini_file['Temperature']['CM3'];
    if (empty($intTemp)) {
        echo "N/A";
        return "N/A"; 
    }
    else {
        echo $intTemp;
        return $intTemp;
    }
}

# get firmware version from mcu
function getVersion() {
    # read in .ini file
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $output_mcu_version = $ini_file['MCU']['Version'];
    if (empty($output_mcu_version)) {
	echo "N/A";


    }
    else {
        echo $output_mcu_version;
        return $output_mcu_version;
    }
}

# set software version
function getSWVersion() {
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $output_sw_version = $ini_file['Compute']['SoftwareVersion'];
    if (empty($output_sw_version)) {
        echo "N/A";
    }
    else {
        echo $output_sw_version;
        return $output_sw_version;
    }
}

# get battery state
function getBatteryState() {
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $output_bat_state = $ini_file['Battery']['State'];
    if ($output_bat_state == "0"){
        $bat_state_str = "Discharging";
    } elseif ($output_bat_state == "1") {
        $bat_state_str = "Charging";
    } elseif ($output_bat_state == "2") {
        $bat_state_str = "Fully Charged";
    } else {
        $bat_state_str = "Fault";
    }
    echo $bat_state_str;
    return $bat_state_str;
}

# get battery voltage
function getBatteryVoltage() {
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $output_bat_v = $ini_file['Battery']['Voltage'];
    if (empty($output_bat_v)) {
        echo "N/A";
        return "N/A"; 

    }
    else {
        echo $output_bat_v;
        return $output_bat_v;
    }
}

# get battery current
function getBatteryCurrent() {
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $output_bat_i = $ini_file['Battery']['Current'];
    if (empty($output_bat_i)) {
        echo "N/A";
        return "N/A"; 
    }
    else {
        echo $output_bat_i;
        return $output_bat_i;
    }
}

# get sonde state
function getSondeState() {
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $sonde_state = $ini_file['Sonde']['Enabled'];
    if ($sonde_state == "1"){
        $sonde_state_str = "On";
    } else {
        $sonde_state_str = "Off";
    }
    echo $sonde_state_str;
    return $sonde_state_str;
}

# get raw coiler value
function getCoilerValue() {
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $coiler = $ini_file['Camera']['Coiler'];
    # multiplication
    echo (intval($coiler) * 0.125);
}

# get lamp value
function getLampValue() {
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $lamp = $ini_file['Camera']['Lamp'];
    if ($lamp == "-1") {
        echo "Off";
    }
    else if (empty($lamp)) {
        echo "0%";
    }
    else {
	    $lamp .= "%";
        echo $lamp;
    }
}

# get compute thermistor value
function getThermistorValue() {
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini");
    $thermistor = $ini_file['Temperature']['CM3'];
    echo ((intval($thermistor) / 100.0));
}

# log reset
function logReset() {
    $myfile = fopen("commands.txt", "wb") or die("Unable to open file commands");
    $txt = "LOGRST";
    fwrite($myfile, $txt);
    fclose($myfile);
}

# sonde on
function sondeOn() {
    $myfile = fopen("commands.txt", "wb") or die("Unable to open file commands");
    $txt = "SONDE 1";
    fwrite($myfile, $txt);
    fclose($myfile);
}

function sondeOff() {
    $myfile = fopen("commands.txt", "wb") or die("Unable to open file!");
    $txt = "SONDE 0";
    fwrite($myfile, $txt);
    fclose($myfile);
}

function lampup() {
    $myfile = fopen("commands.txt", "wb") or die("Unable to open file!");
    $txt = "LAMPUP";
    fwrite($myfile, $txt);
    fclose($myfile);
}

function lampdown() {
    $myfile = fopen("commands.txt", "wb") or die("Unable to open file!");
    $txt = "LAMPDOWN";
    fwrite($myfile, $txt);
    fclose($myfile);
}

function lampoff() {
    $myfile = fopen("commands.txt", "wb") or die("Unable to open file!");
    $txt = "LAMPOFF";
    fwrite($myfile, $txt);
    fclose($myfile);
}

function resetMeterage() {
    $myfile = fopen("commands.txt", "wb") or die("Unable to open file!");
    $txt = "RESET";
    fwrite($myfile, $txt);
    fclose($myfile);
}

function getVInter()
{
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $txt = $ini_file['Voltage']['Inter'];
    echo $txt;
    return $txt; 
}

function getVEnc()
{
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $txt = $ini_file['Voltage']['Encoder'];
    echo $txt;
    return $txt;
}

function getVCam()
{
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $txt = $ini_file['Voltage']['Camera'];
    echo $txt;
    return $txt;
}

function getVSonde()
{
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $txt = $ini_file['Voltage']['Sonde'];
    echo $txt;
    return $txt;
}

function getILEDOut()
{
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $txt = $ini_file['Current']['LedOut'];
    echo $txt;
    return $txt;
}

function getILEDMxp()
{
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $txt = $ini_file['Current']['LedMaxprobe'];
    echo $txt;
    return $txt;
}

function getIInter()
{
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $txt = $ini_file['Current']['Inter'];
    echo $txt;
    return $txt;
}

function getTempBoost()
{
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $txt = $ini_file['Temperature']['Boost'];
    echo $txt/100;
    return $txt/100;
}

function getTempLED()
{
    $ini_file = parse_ini_file("/home/pi/PE2327/bin/PE2327.ini",true);
    $txt = $ini_file['Temperature']['LED'];
    echo $txt/100;
    return $txt/100;
}

?>


