
  <?php   
  include 'phpFunctions.php'; 
  include 'download_mcu_log.php';
 /* 
 Structure of Report 
	Title: X-Range Summary Report

	Date and Time 

	MEASUREMENTS 

	  	CONTROL BOARD 
		  	Battery Voltage 
		  	Battery Current Draw 
		  	CM3 Internal Temperature 
		  	Thermistor Internal Temperature 
	  	
	  	ENCODER BOARD
		  	Interstage Voltage
		  	Encoder Board Voltage 
		  	Camera Voltage 
		  	LED Current
		  	Sonde Voltage 
		  	BC Temperature 




  		FAULT RECORD 

  			EVENTS 
  				Number of boot fails:

  			CURRENT 
  				Number of Overcurrents:  
  					Last Value: 


  			VOLTAGE
  				Number of Overvoltages:
  					Last Value: 
  				Number of Undervoltage: 
  					Last Value: 

  			TEMPERATURE
  				Number of Overtemperatures: 
  					Last Value: 

  				Number of Undertemperatures:
  					Last Value: 

  //get the variables and placing them into an array of strings 

  // strval uses what the function returns to convert to a string

  */


       //function to handle case of zero faults before printing in the text file 

   function handle_zero_fault($fault_count,$fault_value) {
   		//if no faults have occurred
        if($fault_count ==0) {
        	//print "N/A"
            return "N/A"; 
        }

        else {
        	//if the fault has occurred, output the fault value

            return $fault_value; 
        }

     }


	$str_array = array("System Status",
						"--------------------------",
						"Battery Voltage " . strval(getBatteryVoltage()) . " mV",
						"Battery Current " . strval(getBatteryCurrent()) . " mA",
						"Battery is " . strval(getBatteryState()),
						"CM3 Internal Temperature " . strval(getInternalTemperature()) . "°C",
						"Internal Thermistor Temperature " . strval(getInternalThermistorTemperature()) . "°C",
						" ",
						"Diagnostics",
						"--------------------------",
						"Interstage Voltage " . strval(getVInter()) . " mV",
						"Interstage Current " . strval(getIInter()) . " mA",
						"Encoder Board Voltage " . strval(getVEnc()) . " mV",
						"Camera Voltage " . strval(getVCam()) . " mV",
						"LED Current " . strval(getILEDOut()) . " mA",
						"LED Temperature " . strval(getTempLED()) . " °C",
						"Maxprobe LED Current " . strval(getILEDMxp()) . " mA",
						"Sonde Voltage " . strval(getVSonde()) . " mV",
						"Boost Converter Temperature " . strval(getTempBoost()) . " °C",
						" ",
						"Boot Counts",
						"--------------------------",
						"System has successfully booted " . strval($events_boot_success_decimal) . " time(s)", 
						"System has failed to boot " . strval($events_boot_fail_decimal) . " time(s)", 
						" ",
						"Fault Logs",
						"--------------------------",
						"System has had " . strval($ov_count_occ_decimal) . " overvoltages with last fault being at " . strval(handle_zero_fault($ov_count_occ_decimal,$ov_last_val_decimal)) . " mV",						
						"System has had " . strval($uv_count_occ_decimal) . " undervoltages with last fault being at " . strval(handle_zero_fault($uv_count_occ_decimal,$uv_last_val_decimal)) . " mV",					
						"System has had " . strval($oc_count_occ_decimal) . " overcurrents with last fault being at " . strval(handle_zero_fault($oc_count_occ_decimal,$oc_last_val_decimal)) . " mA",					
						"System has had " . strval($ot_count_occ_decimal) . " overtemperatures with last fault being at " . strval(handle_zero_fault($ot_count_occ_decimal,$ot_last_val_decimal)) . " °C",				
						"System has had " . strval($ut_count_occ_decimal) . " undertemperature with last fault being at " . strval(handle_zero_fault($ut_count_occ_decimal,$ut_last_val_decimal)) . " °C");
  //array of string variables 
 // open a text file (will create if it doesn't exist) named report.txt
  $report_file = fopen("X-Range_Summary_Report.txt", "w") or die("Unable to open file!");
  //write "Summary of System" as the title as the top of the file 
  //Title the page "Summary of Syste, State" at the top
  //this writes that title to the first line of the file 
   fwrite($report_file,"X-Range System Summary Report\n");
   //current date and time
   fwrite($report_file,"Date:  "); 
   fwrite($report_file,date("d/m/Y")); 
   fwrite($report_file,"\n"); 
   fwrite($report_file,"Time:  "); 
   fwrite($report_file,date("H:i:s"));
   fwrite($report_file,"\n"); 
   fwrite($report_file,"Software Version:  ");  
   fwrite($report_file,strval(getSWVersion()));
   fwrite($report_file,"\n"); 
   fwrite($report_file,"Firmware Version:  ");  
   fwrite($report_file,strval(getVersion()));
   fwrite($report_file,"\n\n"); 

 //loop through all the strings in the array 

  for($i = 0; $i < count($str_array); $i++){
  	//write the value of the string (in this particular array element) to the text file, then write a new line 
  		fwrite($report_file,$str_array[$i]);
  		//start a new line before outputting next string 
  		fwrite($report_file,"\n" ); 
  }
  
  fclose($report_file);

?>








 