<?php
    //linking this with the status.html file to retrieve hexadecimal string 
     $fh = fopen("bin/mcu_log.log", 'r');
     $fz = filesize("bin/mcu_log.log");
     $pageText = fread($fh, $fz);
     //echo nl2br($pageText);

     //function to swap bytes to correct order  (i.e. correct powers of 16 applied at the right place e.g. interpret number as 0019 instead of 1900) before hexdec conversion. MCU outputs PAIRS of bytes in reverse order, so swapping PAIRS of bytes is neccessary.


     function swap_and_hexdec_2_bytes($two_byte_string) {

      $two_byte_string_byte1 = substr($two_byte_string,0,2);
      $two_byte_string_byte2 = substr($two_byte_string,2,2);
      return hexdec($two_byte_string_byte2.$two_byte_string_byte1); 
     }

//function to swap bytes as shown above, no hexdex conversion. This is for 'state of first occurence' and 'state of last occurence' for faults: oc,ov,uv,ut and ot (want to leave in hex format)

      function two_byte_swap_only($two_byte_string) {

      $two_byte_string_byte1 = substr($two_byte_string,0,2);
      $two_byte_string_byte2 = substr($two_byte_string,2,2);
      return $two_byte_string_byte2.$two_byte_string_byte1; 
     }

   //function for swapping of bytes for RFU of event (want to leave in hex format)

   function four_byte_swap_only($four_byte_string) {

      $four_byte_string_byte1 = substr($four_byte_string,0,2);
      $four_byte_string_byte2 = substr($four_byte_string,2,2);
      $four_byte_string_byte3 = substr($four_byte_string,4,2);
      $four_byte_string_byte4 = substr($four_byte_string,6,2);

      return $four_byte_string_byte4.$four_byte_string_byte3.$four_byte_string_byte2.$four_byte_string_byte1; 
     }



     //function for swapping of bytes for RFU of faults: oc,ov,ut,ot, (want to leave in hex format)

     function six_byte_swap_only($six_byte_string) {

      $six_byte_string_byte1 = substr($six_byte_string,0,2);
      $six_byte_string_byte2 = substr($six_byte_string,2,2);
      $six_byte_string_byte3 = substr($six_byte_string,4,2);
      $six_byte_string_byte4 = substr($six_byte_string,6,2);
      $six_byte_string_byte5 = substr($six_byte_string,8,2);
      $six_byte_string_byte6 = substr($six_byte_string,10,2);

      return $six_byte_string_byte6.$six_byte_string_byte5.$six_byte_string_byte4.$six_byte_string_byte3.$six_byte_string_byte2.$six_byte_string_byte1; 
     }
     
    //mcu_log gives hex stream, length of 109 characters 

    //breaking up mcu_log (pageText) into sections specified in the log structure 
     //signature, 4 bytes, 8 characters  
     $signature_string = substr($pageText,0,8); 

////LOG HEADER (LOG HEADER)/////
     //version string, 8 bytes, 16 characters 
     $version_string = substr($pageText,8,16); 
         //log version number (no swapping needed, only 1 byte)
         $log_v_string = substr($version_string,0,2); 
         //convert to hexadecimal 
         $log_v_decimal = hexdec($log_v_string);

         $fw_v_major_string = substr($version_string,2,2);
         $fw_v_major_decimal = hexdec($fw_v_major_string); 

         $fw_v_minor_string = substr($version_string,4,2);
         $fw_v_minor_decimal = hexdec($fw_v_minor_string); 

         $fw_v_patch_string = substr($version_string,6,2); 
         $fw_v_patch_decimal = hexdec($fw_v_patch_string); 
//RFU string (leaving in hex format)
         $v_rfu_string = substr($version_string,8,8); 
      



////EVENTS///////
     //EVENTS string, 16 bytes, 32 characters 
     $events_string = substr($pageText,24,32); 

        // get first 2 bytes (4 characters) of 'events' string (for the charger event)
        $events_charger_string = substr($events_string,0,4);
        //seperate the bytes to get MSB and LSB correct 
        //take 'events_charger' string as a hex value (string argument), convert to decimal 
        $events_charger_decimal = swap_and_hexdec_2_bytes($events_charger_string);

        //third and fourth bytes: Number of resets
        $events_reset_string = substr($events_string,4,4); 
        //'reset' hex to decimal 
        $events_reset_decimal = swap_and_hexdec_2_bytes($events_reset_string); 

        //5th and 6th bytes: Number of boot fails 
        $events_boot_fail_string = substr($events_string,8,4); 
        //swap bytes to correct order then convert to decimal 
        $events_boot_fail_decimal=swap_and_hexdec_2_bytes($events_boot_fail_string);

        //7th and 8th characters: Number of boot successes 
        $events_boot_success_string = substr($events_string,12,4); 
        //swap bytes to correct order then convert to decimal 
        $events_boot_success_decimal=swap_and_hexdec_2_bytes($events_boot_success_string); 

        //9th and 10th bytes: Number of maxprobe connects
        $events_mp_string = substr($events_string,16,4); 
        //swap bytes to correct order and convert to decimal
        $events_mp_decimal=swap_and_hexdec_2_bytes($events_mp_string);

        //11th and 12th bytes: Number of shutdowns
        $events_sd_string = substr($events_string,20,4);
        //swap bytes to correct order and convert to decimal
       $events_sd_decimal= swap_and_hexdec_2_bytes($events_sd_string);

        //13th to 16th bytes: RFU bytes 
        $events_rfu_string = substr($events_string,24,8);
        //swap bytes around to be read in correct order  
        $events_rfu_swapped_bytes= four_byte_swap_only($events_rfu_string); 


////OVERCURRENT (CURRENT SENSE) /////////

     //OVERCURRENT string, 16 bytes 
      $oc_string = substr($pageText,56,32); 

         //get the first 2 bytes of the 'overcurrent' string (State of first occurence)
         $oc_first_occ_string = substr($oc_string,0,4); 
         //swap bytes
         $oc_first_occ_swapped_bytes = swap_and_hexdec_2_bytes($oc_first_occ_string);

         //get 3rd and 4th bytes: State of last occurence of overcurrent
         $oc_last_occ_string = substr($oc_string,4,4); 
         //swap bytes
         $oc_last_occ_swapped_bytes = swap_and_hexdec_2_bytes($oc_last_occ_string);
  
         //get 5th and 6th bytes: Max overcurrent value 
         $oc_max_string = substr($oc_string,8,4); 
         //max overcurrent hex to decimal conversion 
         $oc_max_decimal = swap_and_hexdec_2_bytes($oc_max_string);  


         //get 7th and 8th characters: Last overcurrent value 
         $oc_last_val_string=substr($oc_string,12,4); 
         //oc last value hex to decimal conversion 
         $oc_last_val_decimal=swap_and_hexdec_2_bytes($oc_last_val_string); 

         //get 9th and 10th characters: Number of overcurrent occurences 
         $oc_count_occ_string=substr($oc_string,16,4); 
         //oc number of occurences hex to decimal conversion
         $oc_count_occ_decimal = swap_and_hexdec_2_bytes($oc_count_occ_string); 

         //get 11th to 16th bytes: RFU 
         $oc_rfu_string=substr($oc_string,20,12); 
         //swap rfu bytes
         $oc_rfu_swapped_bytes= six_byte_swap_only($oc_rfu_string); 








///OVERVOLTAGE //////

      //OVERVOLTAGE string, 16 bytes (32 characters)
      $ov_string = substr($pageText,88,32); 
      //get the first 2 bytes of the 'overvoltage' string (State of first occurence)
      $ov_first_occ_string = substr($ov_string,0,4); 
      //swap bytes
      $ov_first_occ_swapped_bytes = swap_and_hexdec_2_bytes($ov_first_occ_string);

      //get 3rd and 4th bytes: State of last occurence of overvoltage
      $ov_last_occ_string = substr($ov_string,4,4); 
      //swap bytes
      $ov_last_occ_swapped_bytes = swap_and_hexdec_2_bytes($ov_last_occ_string);
     
      //get 5th and 6th bytes: Max overvoltage value 
      $ov_max_string = substr($ov_string,8,4); 
      //max overvoltage hex to decimal conversion 
      $ov_max_decimal = swap_and_hexdec_2_bytes($ov_max_string);  


      //get 7th and 8th characters: Last overvoltage value 
      $ov_last_val_string=substr($ov_string,12,4); 
      //ov last value hex to decimal conversion 
      $ov_last_val_decimal=swap_and_hexdec_2_bytes($ov_last_val_string); 

      //get 9th and 10th characters: Number of overvoltage occurences 
      $ov_count_occ_string=substr($ov_string,16,4); 
      //ov number of occurences hex to decimal conversion
      $ov_count_occ_decimal = swap_and_hexdec_2_bytes($ov_count_occ_string); 

      //get 11th to 16th bytes: RFU 
      $ov_rfu_string=substr($ov_string,20,12); 
      //swap rfu bytes
      $ov_rfu_swapped_bytes= six_byte_swap_only($ov_rfu_string); 




///UNDERVOLTAGE //////

      //UNDERVOLTAGE string, 16 bytes (32 characters)
      $uv_string = substr($pageText,120,32); 
      //get the first 2 bytes of the 'undervoltage' string (State of first occurence)
      $uv_first_occ_string = substr($uv_string,0,4); 
      //swap bytes
      $uv_first_occ_swapped_bytes = swap_and_hexdec_2_bytes($uv_first_occ_string);

      //get 3rd and 4th bytes: State of last occurence of undervoltage
      $uv_last_occ_string = substr($uv_string,4,4); 
      //swap bytes
      $uv_last_occ_swapped_bytes = swap_and_hexdec_2_bytes($uv_last_occ_string);
     
      //get 5th and 6th bytes: Max undervoltage value 
      $uv_max_string = substr($uv_string,8,4); 
      //max undervoltage hex to decimal conversion 
      $uv_max_decimal = swap_and_hexdec_2_bytes($uv_max_string);  


      //get 7th and 8th characters: Last undervoltage value 
      $uv_last_val_string=substr($uv_string,12,4); 
      //uv last value hex to decimal conversion 
      $uv_last_val_decimal=swap_and_hexdec_2_bytes($uv_last_val_string); 

      //get 9th and 10th characters: Number of undervoltage occurences 
      $uv_count_occ_string=substr($uv_string,16,4); 
      //uv number of occurences hex to decimal conversion
      $uv_count_occ_decimal = swap_and_hexdec_2_bytes($uv_count_occ_string); 

      //get 11th to 16th bytes: RFU 
      $uv_rfu_string=substr($uv_string,20,12); 
      //swap rfu bytes
      $uv_rfu_swapped_bytes= six_byte_swap_only($uv_rfu_string); 



///UNDERTEMPERATURE //////

   //UNDERTEMPERATURE string, 16 bytes (32 characters)
   $ut_string = substr($pageText,152,32); 
      //get the first 2 bytes of the 'undertemperature' string (State of first occurence)
      $ut_first_occ_string = substr($ut_string,0,4); 
      //swap bytes
      $ut_first_occ_swapped_bytes = swap_and_hexdec_2_bytes($ut_first_occ_string);

      //get 3rd and 4th bytes: State of last occurence of undertemperature
      $ut_last_occ_string = substr($ut_string,4,4); 
      //swap bytes
      $ut_last_occ_swapped_bytes = swap_and_hexdec_2_bytes($ut_last_occ_string);
     
      //get 5th and 6th bytes: Max undertemperature value 
      $ut_max_string = substr($ut_string,8,4); 
      //max undertemperature hex to decimal conversion 
      $ut_max_decimal = swap_and_hexdec_2_bytes($ut_max_string);  


      //get 7th and 8th characters: Last undertemperature value 
      $ut_last_val_string=substr($ut_string,12,4); 
      //uv last value hex to decimal conversion 
      $ut_last_val_decimal=swap_and_hexdec_2_bytes($ut_last_val_string); 

      //get 9th and 10th characters: Number of undertemperature occurences 
      $ut_count_occ_string=substr($ut_string,16,4); 
      //ut number of occurences hex to decimal conversion
      $ut_count_occ_decimal = swap_and_hexdec_2_bytes($ut_count_occ_string); 

      //get 11th to 16th bytes: RFU 
      $ut_rfu_string=substr($ut_string,20,12); 
      //swap rfu bytes
      $ut_rfu_swapped_bytes= six_byte_swap_only($ut_rfu_string); 

///OVERTEMPERATURE //////

   //OVERTEMPERATURE string, 16 bytes (32 characters)
   $ot_string = substr($pageText,184,32); 
      //get the first 2 bytes of the 'overtemperature' string (State of first occurence)
      $ot_first_occ_string = substr($ot_string,0,4); 
      //swap bytes
      $ot_first_occ_swapped_bytes = swap_and_hexdec_2_bytes($ut_first_occ_string);

      //get 3rd and 4th bytes: State of last occurence of undertemperature
      $ot_last_occ_string = substr($ut_string,4,4); 
      //swap bytes
      $ot_last_occ_swapped_bytes = swap_and_hexdec_2_bytes($ot_last_occ_string);
     
      //get 5th and 6th bytes: Max overtemperature value 
      $ot_max_string = substr($ot_string,8,4); 
      //max undertemperature hex to decimal conversion 
      $ot_max_decimal = swap_and_hexdec_2_bytes($ot_max_string);  


      //get 7th and 8th characters: Last overtemperature value 
      $ot_last_val_string=substr($ot_string,12,4); 
      //ot last value hex to decimal conversion 
      $ot_last_val_decimal=swap_and_hexdec_2_bytes($ot_last_val_string); 

      //get 9th and 10th characters: Number of undertemperature occurences 
      $ot_count_occ_string=substr($ot_string,16,4); 
      //ot number of occurences hex to decimal conversion
      $ot_count_occ_decimal = swap_and_hexdec_2_bytes($ot_count_occ_string); 

      //get 11th to 16th bytes: RFU 
      $ot_rfu_string=substr($ot_string,20,12); 
      //swap rfu bytes
      $ot_rfu_swapped_bytes= six_byte_swap_only($ot_rfu_string); 

?>

